/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.tile.grid;

import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.api.network.INetwork;
import com.raoulvdberge.refinedstorage.api.network.grid.GridType;
import com.raoulvdberge.refinedstorage.api.network.grid.IGridCraftingListener;
import com.raoulvdberge.refinedstorage.api.util.IStackList;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.item.ItemWirelessCraftingGrid;
import com.raoulvdberge.refinedstorage.tile.grid.WirelessGrid;
import com.raoulvdberge.refinedstorage.util.StackUtils;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;

public class WirelessCraftingGrid
extends WirelessGrid {
    public static int ID;
    private final int controllerDimension;
    private IRecipe currentRecipe;
    private final InventoryCrafting matrix;
    private final InventoryCraftResult result;
    private final Set<IGridCraftingListener> craftingListeners;

    public WirelessCraftingGrid(ItemStack stack, final boolean server, int slotId) {
        super(stack, slotId);
        Container craftingContainer = new Container(){

            public boolean func_75145_c(@Nonnull EntityPlayer playerIn) {
                return false;
            }

            public void func_75130_a(@Nonnull IInventory inventoryIn) {
                if (server) {
                    WirelessCraftingGrid.this.onCraftingMatrixChanged();
                }
            }
        };
        this.matrix = new InventoryCrafting(craftingContainer, 3, 3);
        this.result = new InventoryCraftResult();
        this.craftingListeners = new HashSet<IGridCraftingListener>();
        this.controllerDimension = ItemWirelessCraftingGrid.getDimensionId(stack);
        if (stack.func_77942_o()) {
            StackUtils.readItems((IInventory)this.matrix, 1, stack.func_77978_p());
        }
    }

    @Override
    public String getGuiTitle() {
        return "gui.refinedstorage:crafting_grid";
    }

    @Override
    public GridType getGridType() {
        return GridType.CRAFTING;
    }

    @Override
    public InventoryCrafting getCraftingMatrix() {
        return this.matrix;
    }

    @Override
    public InventoryCraftResult getCraftingResult() {
        return this.result;
    }

    @Override
    public void onCraftingMatrixChanged() {
        if (this.currentRecipe == null || !this.currentRecipe.func_77569_a(this.matrix, (World)DimensionManager.getWorld((int)this.controllerDimension))) {
            this.currentRecipe = CraftingManager.func_192413_b((InventoryCrafting)this.matrix, (World)DimensionManager.getWorld((int)this.controllerDimension));
        }
        if (this.currentRecipe == null) {
            this.result.func_70299_a(0, ItemStack.field_190927_a);
        } else {
            this.result.func_70299_a(0, this.currentRecipe.func_77572_b(this.matrix));
        }
        this.craftingListeners.forEach(IGridCraftingListener::onCraftingMatrixChanged);
        if (!this.getStack().func_77942_o()) {
            this.getStack().func_77982_d(new NBTTagCompound());
        }
        StackUtils.writeItems((IInventory)this.matrix, 1, this.getStack().func_77978_p());
    }

    @Override
    public void onCrafted(EntityPlayer player, @Nullable IStackList<ItemStack> availableItems, @Nullable IStackList<ItemStack> usedItems) {
        INetwork network = this.getNetwork();
        if (network != null) {
            network.getNetworkItemHandler().drainEnergy(player, RS.INSTANCE.config.wirelessCraftingGridCraftUsage);
        }
        API.instance().getCraftingGridBehavior().onCrafted(this, this.currentRecipe, player, availableItems, usedItems);
    }

    @Override
    public void onCraftedShift(EntityPlayer player) {
        INetwork network = this.getNetwork();
        if (network != null) {
            network.getNetworkItemHandler().drainEnergy(player, RS.INSTANCE.config.wirelessCraftingGridCraftUsage);
        }
        API.instance().getCraftingGridBehavior().onCraftedShift(this, player);
    }

    @Override
    public void onRecipeTransfer(EntityPlayer player, ItemStack[][] recipe) {
        API.instance().getCraftingGridBehavior().onRecipeTransfer(this, player, recipe);
    }

    @Override
    public void onClear(EntityPlayer player) {
        API.instance().getCraftingGridBehavior().onClear(this, player);
    }

    @Override
    public void addCraftingListener(IGridCraftingListener listener) {
        this.craftingListeners.add(listener);
    }

    @Override
    public void removeCraftingListener(IGridCraftingListener listener) {
        this.craftingListeners.remove(listener);
    }
}

